function [sofiImage, averageImage] = sofi()
%sofi Example function showing how to perform a sofi analysis.
%   Execute "LocalizerMatlab('sofi') for a help message.
%   
%   Note that the deconvolution or Fourier reweighing functionality is not
%   built-in at this stage, but can be obtained using e.g. deconvlucy() in
%   the matlab image toolbox.

    [fileName,pathName] = uigetfile();
    if isequal(fileName,0)
        return
    end
    filePath = strcat(pathName, fileName);
    
    order = 2;
    doCrossCorrelation = 1;
    lagTimes = 0;
    framesToSkip = -1;
    framesToInclude = -1;

    [sofiImage, averageImage] = LocalizerMatlab('sofi', order, doCrossCorrelation, lagTimes, framesToSkip, framesToInclude, filePath);
    %[sofiImage, averageImage] = LocalizerMatlab('newsofi', order, 0, filePath);

end

